package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 授信核销单据信息dto
 *
 * @author ning.zhang
 * @date 2021/12/21
 */
@Data
@ApiModel(value = "CreditWriteOffOrderDto", description = "授信核销单据信息dto")
public class CreditWriteOffOrderDto extends TenantDto {

  /**
   * 金额
   */
  @ApiModelProperty("金额")
  private BigDecimal amount;

  /**
   * 单据编码
   */
  @ApiModelProperty("单据编码")
  private String orderCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 单据类型
   */
  @ApiModelProperty(value = "单据剩余金额", hidden = true)
  private BigDecimal remainAmount;

}
