package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 资金调整操作枚举
 *
 * @author ning.zhang
 * @date 2021/12/16
 */
@Getter
@AllArgsConstructor
public enum CashAdjustOperateEnum {

  /**
   * 资金调整操作枚举取值
   */
  TEMPORARY_CREDIT("cashAdjustType", "temporaryCredit", "临时授信", "0", CashAdjustGroupEnum.ON),
  OPEN_CREDIT("cashAdjustType", "openCredit", "开通授信", "1", CashAdjustGroupEnum.ON),
  DOWN_UP_ACCOUNT("cashAdjustType", "downUpAccount", "回款上账", "2", CashAdjustGroupEnum.ON),
  CLOSE_ORDER("cashAdjustType", "closeOrder", "关闭订单", "3", CashAdjustGroupEnum.ON),
  ORDER("cashAdjustType", "order", "订单订货", "4", CashAdjustGroupEnum.USE),
  RETURN_ORDER("cashAdjustType", "returnOrder", "订单回退", "5", CashAdjustGroupEnum.ON),
  FREEZE_UNFREEZE("cashAdjustType", "freezeUnfreeze", "冻结/解冻", "6", CashAdjustGroupEnum.ON),
  CHANGE_CREDIT("cashAdjustType", "changeCredit", "授信变更", "7", CashAdjustGroupEnum.ON),
  CREDIT_WRITE_OFF("cashAdjustType", "creditWriteOff", "信用核销", "8", CashAdjustGroupEnum.ON),
  OCCUPY_USE("cashAdjustType", "occupyUse", "占用使用", "11", CashAdjustGroupEnum.OCCUPY),
  OCCUPY_RELEASE("cashAdjustType", "occupyRelease", "占用释放", "12", CashAdjustGroupEnum.OCCUPY),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 上账/使用
   */
  private CashAdjustGroupEnum groupEnum;

  /**
   * 通过dictCode获取 枚举
   *
   * @param dictCode  字典编码
   * @return 枚举
   */
  public static CashAdjustOperateEnum getByDictCode(String dictCode) {
    return Arrays.stream(CashAdjustOperateEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }

  /**
   * 通过大类获取资授信作类型集合
   * @param bigType
   * @return
   */
  public static List<String> getDictCodeByGroupEnum(CashAdjustGroupEnum groupEnum){
    List<String> bigTypeList = Arrays.stream(CashAdjustOperateEnum.values())
        .filter(item -> Objects.equals(item.getGroupEnum(), groupEnum))
        .map(CashAdjustOperateEnum::getDictCode)
        .collect(Collectors.toList());
    return bigTypeList;
  }
}
