package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 资金调整类型枚举
 *
 * @author ning.zhang
 * @date 2021/12/16
 */
@Getter
@AllArgsConstructor
public enum CashAdjustTypeEnum {

  /**
   * 资金调整类型枚举取值
   */
  TEMPORARY_CREDIT("cashAdjustOperate", "temporaryCredit", "临时授信","0"),
  OPEN_CREDIT("cashAdjustOperate", "openCredit", "开通授信","1"),
  CUSTOMER_UP_ACCOUNT("cashAdjustOperate", "customerUpAccount", "客户回款","2"),
  WRITE_OFF_UP_ACCOUNT("cashAdjustOperate", "writeOffUpAccount", "核销上账","3"),
  CREDIT_RELEASE("cashAdjustOperate", "creditRelease", "信用回退","4"),
  CREDIT_REDUCE("cashAdjustOperate", "creditReduce", "信用扣减","5"),
  FREEZE_UNFREEZE("cashAdjustOperate",  "freezeUnfreeze", "冻结/解冻","6"),
  CHANGE_CREDIT("cashAdjustOperate", "changeCredit", "授信变更","7"),
  CREDIT_WRITE_OFF("cashAdjustOperate", "creditWriteOff", "信用核销", "8"),
  OCCUPY_USE("cashAdjustOperate", "occupyUse", "信用占用","11"),
  OCCUPY_RELEASE("cashAdjustOperate", "occupyRelease", "信用释放","12"),
  OTHER("cashAdjustOperate",  "other", "其他","100"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过dictCode获取 枚举
   *
   * @param dictCode  字典编码
   * @return 枚举
   */
  public static CashAdjustTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(CashAdjustTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
