package com.biz.crm.dms.business.costpool.credit.sdk.enums;


import java.util.Arrays;
import java.util.Objects;

/**
 * 授信费用池类型
 *
 * @author ning.zhang
 * @date 2022/1/20
 */
public enum CreditPoolTypeEnum {

  //费用池类型取值
  CREDIT("credit", "credit", "授信费用池", "1"),;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CreditPoolTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CreditPoolTypeEnum
   *
   * @param key 枚举key
   * @return CreditPoolTypeEnum
   */
  public static CreditPoolTypeEnum getByKey(String key) {
    return Arrays.stream(CreditPoolTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
