package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 授信核销状态
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Getter
@AllArgsConstructor
public enum CreditWriteOffStatus {

  //授信核销状态取值
  NOT_ARRIVE_WRITE_OFF_TIME("creditWriteOffStatus","not_arrive_write_off_time","未到核销时间","1"),
  WAIT_REPAY("creditWriteOffStatus","wait_repay","待还款","2"),
  OVERDUE_NOT_REPAY("creditWriteOffStatus","overdue_not_repay","逾期未还款","3"),
  HAVE_SETTLE("creditWriteOffStatus","have_settle","已结清","4"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
