package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 占用类型
 *
 * @author pengxi
 * @date 2022/6/27
 */
@Getter
@AllArgsConstructor
public enum OccupyTypeEnum {

  /**
   * 占用类型
   */
  OCCUPY("occupy","occupy","占用","0"),
  RELEASE("release","release","释放","1"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过dictCode获取 枚举
   *
   * @param dictCode  字典编码
   * @return 枚举
   */
  public static OccupyTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(OccupyTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }
}
