package com.biz.crm.dms.business.costpool.credit.sdk.event;

import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditEventVo;

import java.util.List;

/**
 * 授信事件监听
 *
 * @author ning.zhang
 * @date 2021/12/15
 */
public interface CreditEventListener {

  /**
   * 当授信新增是触发(存在批量新增的情况)
   *
   * @param voList 新增的授信信息集合
   */
  void onCreate(List<CreditEventVo> voList);

  /**
   * 当授信修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(CreditEventVo oldVo, CreditEventVo newVo);

  /**
   * 当授信禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<CreditEventVo> voList);

  /**
   * 当授信启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<CreditEventVo> voList);

  /**
   * 当授信审批时触发
   *
   * @param voList 审批的授信信息集合
   */
  void onApprove(List<CreditEventVo> voList);
}
