package com.biz.crm.dms.business.costpool.credit.sdk.register;

import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;

import java.util.List;

/**
 * 授信资金流水注册器
 * <p>
 * 此注册器用于资金流水变动,然后对流水变动拆分绑定到具体授信信息且更新授信资金信息
 *
 * @author ning.zhang
 * @date 2021/12/15
 */
public interface CreditCashFlowRegister<T extends AbstractCreditCashFlowDto> {

  /**
   * 获取拆分注册器针对的class
   *
   * @return 拆分注册器针对的class
   */
  Class<T> getClazz();

  /**
   * 创建授信流水信息
   *
   * @param dto 参数dto
   * @return 资金流水变动后的客户相关授信资金信息列表
   */
  List<CreditCashVo> onCreate(T dto);

  /**
   * 通过扩展数据查询资金流水相关联扩展数据
   *
   * @param dto 参数dto
   * @return 资金流水相关联扩展数据
   */
  List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto);
}
