package com.biz.crm.dms.business.costpool.credit.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowCustomerDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowVo;
import org.springframework.data.domain.Pageable;

/**
 * 授信资金流水VO服务接口类
 *
 * @author ning.zhang
 * @date 2021/12/18
 */
public interface CreditCashFlowVoService {

  /**
   * 授信资金流水分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCashFlowVo>授信资金流水
   */
  Page<CreditCashFlowVo> findByConditions(Pageable pageable, CreditCashFlowPageDto dto);

  /**
   * 客户-商城授信资金流水分页列表
   * @param pageable
   * @param dto
   * @return
   */
  Page<CreditCashFlowVo> findByCreditCashFlowCustomerDto(Pageable pageable, CreditCashFlowCustomerDto dto);
}
