package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 抽象授信资金流水信息Vo
 *
 * @author ning.zhang
 * @date 2021/12/1
 */
@Data
@EqualsAndHashCode(callSuper = false)
public abstract class AbstractCreditCashFlowVo extends TenantVo {

  private static final long serialVersionUID = 880428170847132842L;

  /**
   * 调整操作编码
   */
  @ApiModelProperty("调整操作编码")
  private String adjustOperateCode;

  /**
   * 调整操作名称
   */
  @ApiModelProperty("调整操作名称")
  private String adjustOperateName;

  /**
   * 调整类型编码
   */
  @ApiModelProperty("调整类型编码")
  private String adjustTypeCode;

  /**
   * 调整类型名称
   */
  @ApiModelProperty("调整类型名称")
  private String adjustTypeName;

  /**
   * 操作金额
   */
  @ApiModelProperty("操作金额")
  private BigDecimal operateAmount;

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  private String cashSerialNumber;

}
