package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 授信信息VO
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditVo", description = "授信信息VO")
public class CreditVo extends WorkflowFlagOpVo {

  private static final long serialVersionUID = 6518107378635664492L;

  /**
   * 授信编码
   */
  @ApiModelProperty("授信编码")
  private String creditCode;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  private String creditType;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户等级
   */
  @ApiModelProperty("客户等级")
  private String customerLevel;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;

  /**
   * 联系人姓名
   */
  @ApiModelProperty("联系人姓名")
  private String contactName;
  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  private String contactPhone;

  /**
   * 授信总额度
   */
  @ApiModelProperty("授信总额度")
  private BigDecimal totalAmount;

  /**
   * 长期授信额度
   */
  @ApiModelProperty("长期授信额度")
  private BigDecimal longAmount;

  /**
   * 长期授信使用金额
   */
  @ApiModelProperty("长期授信使用金额")
  private BigDecimal longHaveUseAmount;

  /**
   * 长期授信冻结金额
   */
  @ApiModelProperty("长期授信冻结金额")
  private BigDecimal longFreezeAmount;

  /**
   * 长期授信占用金额
   */
  @ApiModelProperty("长期授信占用金额")
  private BigDecimal longOccupyAmount;

  /**
   * 长期授信可用余额
   */
  @ApiModelProperty("长期授信可用余额")
  private BigDecimal longCanUseAmount;

  /**
   * 临时授信额度
   */
  @ApiModelProperty("临时授信额度")
  private BigDecimal temporaryAmount;

  /**
   * 临时授信使用金额
   */
  @ApiModelProperty("临时授信使用金额")
  private BigDecimal temporaryHaveUseAmount;

  /**
   * 临时授信可用余额
   */
  @ApiModelProperty("临时授信可用余额")
  private BigDecimal temporaryCanUseAmount;

  /**
   * 临时授信冻结金额
   */
  @ApiModelProperty("临时授信冻结金额")
  private BigDecimal temporaryFreezeAmount;

  /**
   * 临时授信占用金额
   */
  @ApiModelProperty("临时授信占用金额")
  private BigDecimal temporaryOccupyAmount;

  /**
   * 临时授信状态(wait_start:未开始,wait_repay:待还款,using:使用中,overdue_not_repay:逾期未还款,have_write_off:已核销)
   */
  @ApiModelProperty("临时授信状态(wait_start:未开始,wait_repay:待还款,using:使用中,overdue_not_repay:逾期未还款,have_write_off:已核销)")
  private String temporaryCreditStatus;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 还款截止时间
   */
  @ApiModelProperty("还款截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;

  /**
   * 文件信息
   */
  @ApiModelProperty("文件信息")
  private List<CreditFileVo> fileList;
}
