package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信待核销信息VO
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditWaitWriteOffVo", description = "授信待核销信息VO")
public class CreditWaitWriteOffVo {

  /**
   * 授信金额
   */
  @ApiModelProperty("授信金额")
  private BigDecimal creditAmount;

  /**
   * 待核销金额
   */
  @ApiModelProperty("待核销金额")
  private BigDecimal waitWriteOffAmount;

  /**
   * 待核销明细信息
   */
  @ApiModelProperty("待核销明细信息")
  private List<CreditWriteOffVo> writeOffInfoList;
}
