package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 授信核销统计信息VO
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditWriteOffStatsVo", description = "授信核销统计信息VO")
public class CreditWriteOffStatsVo {

  /**
   * 授信金额
   */
  @ApiModelProperty("授信金额")
  private String creditAmount;

  /**
   * 已使用金额
   */
  @ApiModelProperty("已使用金额")
  private String haveUseAmount;

  /**
   * 已核销金额
   */
  @ApiModelProperty("已核销金额")
  private BigDecimal haveWriteOffAmount;

  /**
   * 待核销金额
   */
  @ApiModelProperty("待核销金额")
  private BigDecimal waitWriteOffAmount;

  /**
   * 核销状态(not_arrive_write_off_time:未到核销时间,not_arrive_write_off_time:未到核销时间,wait_repay:待还款,overdue_not_repay:逾期未还款,have_settle:已结清)
   */
  @ApiModelProperty("核销状态(not_arrive_write_off_time:未到核销时间,not_arrive_write_off_time:未到核销时间,wait_repay:待还款,overdue_not_repay:逾期未还款,have_settle:已结清)")
  private String writeOffStatus;

  /**
   * 待核销数量
   */
  @ApiModelProperty("待核销数量")
  private Integer waitWriteOffNum;
}
