package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 授信核销信息VO
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditWriteOffVo", description = "授信核销信息VO")
public class CreditWriteOffVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 9188225727436474810L;

  /**
   * 授信ID
   */
  @ApiModelProperty("授信ID")
  private String creditId;

  /**
   * 授信编码
   */
  @ApiModelProperty("授信编码")
  private String creditCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 授信金额
   */
  @ApiModelProperty("授信金额")
  private BigDecimal creditAmount;

  /**
   * 待核销金额
   */
  @ApiModelProperty("待核销金额")
  private BigDecimal waitWriteOffAmount;

  /**
   * 已核销金额
   */
  @ApiModelProperty("已核销金额")
  private BigDecimal haveWriteOffAmount;

  /**
   * 核销状态(not_arrive_write_off_time:未到核销时间,not_arrive_write_off_time:未到核销时间,wait_repay:待还款,overdue_not_repay:逾期未还款,have_settle:已结清)
   */
  @ApiModelProperty("核销状态(not_arrive_write_off_time:未到核销时间,not_arrive_write_off_time:未到核销时间,wait_repay:待还款,overdue_not_repay:逾期未还款,have_settle:已结清)")
  private String writeOffStatus;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 还款截止时间
   */
  @ApiModelProperty("还款截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;

  /**
   * 最近核销时间
   */
  @ApiModelProperty("最近核销时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date recentlyWriteOffTime;
}
