/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustGroupEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum CashAdjustOperateEnum {
    TEMPORARY_CREDIT("cashAdjustType", "temporaryCredit", "\u4e34\u65f6\u6388\u4fe1", "0", CashAdjustGroupEnum.ON),
    OPEN_CREDIT("cashAdjustType", "openCredit", "\u5f00\u901a\u6388\u4fe1", "1", CashAdjustGroupEnum.ON),
    DOWN_UP_ACCOUNT("cashAdjustType", "downUpAccount", "\u56de\u6b3e\u4e0a\u8d26", "2", CashAdjustGroupEnum.ON),
    CLOSE_ORDER("cashAdjustType", "closeOrder", "\u5173\u95ed\u8ba2\u5355", "3", CashAdjustGroupEnum.ON),
    ORDER("cashAdjustType", "order", "\u8ba2\u5355\u8ba2\u8d27", "4", CashAdjustGroupEnum.USE),
    RETURN_ORDER("cashAdjustType", "returnOrder", "\u8ba2\u5355\u56de\u9000", "5", CashAdjustGroupEnum.ON),
    FREEZE_UNFREEZE("cashAdjustType", "freezeUnfreeze", "\u51bb\u7ed3/\u89e3\u51bb", "6", CashAdjustGroupEnum.ON),
    CHANGE_CREDIT("cashAdjustType", "changeCredit", "\u6388\u4fe1\u53d8\u66f4", "7", CashAdjustGroupEnum.ON),
    CREDIT_WRITE_OFF("cashAdjustType", "creditWriteOff", "\u4fe1\u7528\u6838\u9500", "8", CashAdjustGroupEnum.ON),
    OCCUPY_USE("cashAdjustType", "occupyUse", "\u5360\u7528\u4f7f\u7528", "11", CashAdjustGroupEnum.OCCUPY),
    OCCUPY_RELEASE("cashAdjustType", "occupyRelease", "\u5360\u7528\u91ca\u653e", "12", CashAdjustGroupEnum.OCCUPY);

    private String key;
    private String dictCode;
    private String value;
    private String order;
    private CashAdjustGroupEnum groupEnum;

    public static CashAdjustOperateEnum getByDictCode(String dictCode) {
        return Arrays.stream(CashAdjustOperateEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode)).findFirst().orElse(null);
    }

    public static List<String> getDictCodeByGroupEnum(CashAdjustGroupEnum groupEnum) {
        List<String> bigTypeList = Arrays.stream(CashAdjustOperateEnum.values()).filter(item -> Objects.equals((Object)item.getGroupEnum(), (Object)groupEnum)).map(CashAdjustOperateEnum::getDictCode).collect(Collectors.toList());
        return bigTypeList;
    }

    public String getKey() {
        return this.key;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getOrder() {
        return this.order;
    }

    public CashAdjustGroupEnum getGroupEnum() {
        return this.groupEnum;
    }

    private CashAdjustOperateEnum(String key, String dictCode, String value, String order, CashAdjustGroupEnum groupEnum) {
        this.key = key;
        this.dictCode = dictCode;
        this.value = value;
        this.order = order;
        this.groupEnum = groupEnum;
    }
}

