package com.biz.crm.dms.business.costpool.credit.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 授信常量类
 *
 * @author ning.zhang
 * @date 2021/12/20
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class CreditConstant {

  /**
   * 授信创建锁key
   */
  public static final String CREDIT_CREATE_LOCK_KEY = "creditCreateLock_%s";

  /**
   * 授信创建资金变动锁key
   */
  public static final String CREDIT_CASH_CHANGE_LOCK_KEY = "creditCashChangeLock_%s";

  /**
   * 授信获取锁超时时间
   */
  public static final Integer CREDIT_TRY_LOCK_OUT_TIME = 20;

  /**
   * 授信获取锁失败提示
   */
  public static final String CREDIT_LOCK_FAIL_MESSAGE = "存在进行中关联操作,请稍后再试!";

  /**
   * 授信还款通知内容
   */
  public static final String CREDIT_REPLAY_NOTICE_CONTENT = "尊敬的客户,目前您的账户信用待还款金额%s元。请及时完成回款，避免造成对您信用分值影响。";

  /**
   * 临时授信发起流程类型名称
   */
  public static final String CREDIT_PROCESS_NAME = "credit";
}
