package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.credit.sdk.dto
 * @ClassName CreditCashFlowCustomerDto
 * @Author YangWei
 * @Date 2022/3/28 下午4:11
 * @Description 商城客户授信Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditCashFlowCustomerDto", description = "商城客户授信Dto")
public class CreditCashFlowCustomerDto extends TenantDto {

  /** 客户编码 */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  private String customerCode;

  /**
   * 资金明细大类（上账/使用）
   */
  @ApiModelProperty(name = "group", value = "资金明细大类（上账/使用)", required = true)
  private String group;

  /** 调整类型集合 */
  @ApiModelProperty(name = "adjustTypeList", value = "调整类型")
  private List<String> adjustTypeList;

  /**
   * 查询期间开始时间
   */
  @ApiModelProperty("查询期间开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;
  /**
   * 查询期间结束时间
   */
  @ApiModelProperty("查询期间结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}