package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 资金流水相关联扩展数据请求dto
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditCashFlowExtendDto", description = "资金流水相关联扩展数据请求dto")
public class CreditCashFlowExtendDto extends TenantDto {

  /**
   * 资金流水号集合
   */
  @ApiModelProperty("资金流水号集合")
  private List<String> cashSerialNumbers;

  /**
   * 单据号集合
   */
  @ApiModelProperty("单据号集合")
  private List<String> orderCodes;
}
