package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 授信资金流水分页请求dto
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditCashFlowPageDto", description = "授信资金流水分页请求dto")
public class CreditCashFlowPageDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 调整类型
   */
  @ApiModelProperty("调整类型")
  private String adjustType;

  /**
   * 单据号
   */
  @ApiModelProperty("单据号")
  private String orderCode;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  private Set<String> cashSerialNumbers;
}
