package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信回款上账dto
 *
 * @author ning.zhang
 * @date 2021/12/17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditDownUpAccountDto", description = "授信回款上账dto")
public class CreditDownUpAccountDto extends TenantDto {

  /**
   * 操作类型(customerUpAccount:客户回款,writeOffUpAccount:核销上账,other:其他)
   */
  @ApiModelProperty(value = "操作类型(customerUpAccount:客户回款,writeOffUpAccount:核销上账,other:其他)")
  private String operateType;

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  private String creditId;

  /**
   * 回款/上账金额(正数表示释放授信额度,负数表示使用授信额度)
   */
  @ApiModelProperty("回款/上账金额(正数表示释放授信额度,负数表示使用授信额度)")
  private BigDecimal downUpAmount;

  /**
   * 单据编码
   */
  @ApiModelProperty("单据编码")
  private String orderCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 文件信息集合
   */
  @ApiModelProperty("文件信息集合")
  private List<CreditFileDto> fileList;
}
