package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 授信冻结/解冻dto
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditFreezeDto", description = "授信冻结/解冻dto")
public class CreditFreezeDto extends TenantDto {

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  private String creditId;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  private String creditType;

  /**
   * 冻结标志(true:冻结,false:解冻)
   */
  @ApiModelProperty("冻结标志(true:冻结,false:解冻)")
  private Boolean freezeFlag;

  /**
   * 冻结额度
   */
  @ApiModelProperty("冻结额度")
  private BigDecimal freezeAmount;

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;
}
