package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 临时授信核销明细分页请求dto
 *
 * @author ning.zhang
 * @date 2021/12/21
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditTempWriteOffPageDto", description = "临时授信核销明细分页请求dto")
public class CreditTempWriteOffPageDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码(授信类型为temporaryCredit需传递)")
  private String customerCode;

  /**
   * 核销状态(not_arrive_write_off_time:未到核销时间,not_arrive_write_off_time:未到核销时间,wait_repay:待还款,overdue_not_repay:逾期未还款,have_settle:已结清)
   */
  @ApiModelProperty("核销状态(not_arrive_write_off_time:未到核销时间,not_arrive_write_off_time:未到核销时间,wait_repay:待还款,overdue_not_repay:逾期未还款,have_settle:已结清)")
  private String writeOffStatus;

  /**
   * 还款截止时间
   */
  @ApiModelProperty("还款截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;

  /**
   * 还款开始时间
   */
  @ApiModelProperty("还款开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayStartTime;
}
