package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * 临时授信分页列表查询dto
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditTemporaryPageDto", description = "临时授信分页列表查询dto")
public class CreditTemporaryPageDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 临时授信状态(waitStart:未开始,waitRepay:待还款,using:使用中,overdueNotRepay:逾期未还款,haveWriteOff:已核销)
   */
  @ApiModelProperty("临时授信状态(waitStart:未开始,waitRepay:待还款,using:使用中,overdueNotRepay:逾期未还款,haveWriteOff:已核销)")
  private String creditStatus;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  private String creditType;

  /**
   * 授信审批状态
   */
  @ApiModelProperty("授信审批状态")
  private String processStatus;

  /**
   * 授信审批状态集合
   */
  @ApiModelProperty("授信审批状态集合")
  private List<String> processStatusList;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  private String createTime;
}
