package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 授信统计请求Dto
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Data
@ApiModel(value = "CreditWriteOffInfoStatsDto", description = "授信统计请求Dto")
public class CreditWriteOffInfoStatsDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码(授信类型为temporaryCredit需传递)")
  private String customerCode;

  /**
   * 授信ID
   */
  @ApiModelProperty("授信ID(授信类型为normalCredit需传递)")
  private String creditId;

  /**
   * 核销授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("核销授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  private String creditType;

}
