package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Project crm-dms
 * @PackageName com.biz.crm.dms.business.costpool.credit.sdk.enums
 * @ClassName CashAdjustGroupEnum
 * @Author YangWei
 * @Date 2022/3/28 下午4:31
 * @Description 授信操作类型分组 上账/使用
 */
public enum CashAdjustGroupEnum {
  /**
   * 上账
   */
  ON ("1", "1", "上账", "1"),

  /**
   * 使用
   */
  USE("2", "2", "使用", "2"),

  /**
   * 占用
   */
  OCCUPY("3", "3", "占用", "3"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CashAdjustGroupEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 CapitalAdjustTypeEnum
   *
   * @param key
   * @return
   */
  public static CashAdjustGroupEnum getByKey(String key) {
    return Arrays.stream(CashAdjustGroupEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}