package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 授信单据类型
 *
 * @author ning.zhang
 * @date 2022/1/21
 */
@Getter
@AllArgsConstructor
public enum CreditOrderTypeEnum {

  //授信单据类型
  SALE_ORDER("creditOrderType", "saleOrder", "销售订单", ""),
  REFUND_ORDER("creditOrderType", "refundOrder", "退款单", ""),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static CreditOrderTypeEnum findByCode(String code) {
    Optional<CreditOrderTypeEnum> first = Stream.of(CreditOrderTypeEnum.values()).filter(t -> t.dictCode.equals(code)).findFirst();
    return first.orElse(null);
  }
}
