package com.biz.crm.dms.business.costpool.credit.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 临时授信状态
 *
 * @author ning.zhang
 * @date 2021/12/17
 */
@Getter
@AllArgsConstructor
public enum TemporaryCreditStatus {

  //临时授信状态取值
  WAIT_START("temporaryCreditStatus","wait_start","未开始","0"),
  WAIT_REPAY("temporaryCreditStatus","wait_repay","待还款","1"),
  USING("temporaryCreditStatus","using","使用中","2"),
  OVERDUE_NOT_REPAY("temporaryCreditStatus","overdue_not_repay","逾期未还款","3"),
  HAVE_WRITE_OFF("temporaryCreditStatus","have_write_off","已核销","4"),
  ;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
