package com.biz.crm.dms.business.costpool.credit.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditVo;
import org.springframework.data.domain.Pageable;

/**
 * 授信Vo服务接口类
 *
 * @author ning.zhang
 * @date 2021/12/16
 */
public interface CreditVoService {

  /**
   * 普通授信信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 普通授信分页信息
   */
  Page<CreditVo> findByCreditCommonPageDto(Pageable pageable, CreditPageDto dto);

  /**
   * 临时授信信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 临时授信分页信息
   */
  Page<CreditVo> findByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto);

  /**
   * 通过普通授信ID获取授信信息
   *
   * @param commonCreditId 普通授信ID
   * @return 授信信息
   */
  CreditVo findByCommonCreditId(String commonCreditId);

  /**
   * 通过授信ID构建资金锁key
   *
   * @param creditId 授信ID
   * @return 资金锁key
   */
  String buildCashLockKeyByCreditId(String creditId);

  /**
   * 通过客户编码构建资金锁key
   *
   * @param customerCode 客户编码
   * @return 资金锁key
   */
  String buildCashLockKeyByCustomerCode(String customerCode);

  /**
   * 客户-商城授信头展示查询
   * @param dto
   * @return
   */
  CreditVo findByTotalCreditDto(CreditDto dto);

  /**
   * 商城-临时授信申请记录信息分页列表
   * @param pageable
   * @param dto
   * @return
   */
  Page<CreditVo> findApplyRecordByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto);

  /**
   * 商城-临时授信记录信息分页列表（审批通过）
   * @param pageable
   * @param dto
   * @return
   */
  Page<CreditVo> findRecordByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto);

  /**
   * 商城临时授信ID获取授信信息
   * @param creditTemporaryId
   * @return
   */
  CreditVo findByCreditTemporaryId(String creditTemporaryId);

  /**
   * 商城临时授信ID获取授信信息
   *
   * @param creditTemporaryCode
   * @return {@link CreditVo}
   */
  CreditVo findByCreditTemporaryCode(String creditTemporaryCode);

  /**
   * 通过普通授信编码获取授信信息
   * @param creditCode
   * @return
   */
  CreditVo findByCreditCode(String creditCode);
}
