package com.biz.crm.dms.business.costpool.credit.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import org.springframework.data.domain.Pageable;

/**
 * 授信核销信息vo服务接口类
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
public interface CreditWriteOffVoService {

  /**
   * 普通授信核销信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditWriteOffVo> 授信核销分页信息
   */
  Page<CreditWriteOffVo> findByConditions(Pageable pageable, CreditWriteOffPageDto dto);

  /**
   * 临时授信核销明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditWriteOffVo> 授信核销分页信息
   */
  Page<CreditWriteOffVo> findByCreditTempWriteOffPageDto(Pageable pageable, CreditTempWriteOffPageDto dto);
}
