package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信流水扩展信息VO
 *
 * @author ning.zhang
 * @date 2021/12/18
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashFlowExtendVo", description = "授信流水扩展信息VO")
public class CreditCashFlowExtendVo {

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  private String cashSerialNumber;

  /**
   * 单据编码
   */
  @ApiModelProperty("单据编码")
  private String orderCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 临时授信金额
   */
  @ApiModelProperty("临时授信金额")
  private BigDecimal temporaryAmount;

  /**
   * 文件信息
   */
  @ApiModelProperty("文件信息")
  private List<CreditFileVo> fileList;
}
