package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 授信流水信息VO
 *
 * @author ning.zhang
 * @date 2021/12/18
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashFlowVo", description = "授信流水信息VO")
public class CreditCashFlowVo extends TenantOpVo {

  private static final long serialVersionUID = -8683399289257762303L;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  private String cashSerialNumber;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 调整操作编码
   */
  @ApiModelProperty("调整操作编码")
  private String adjustOperateCode;

  /**
   * 调整操作名称
   */
  @ApiModelProperty("调整操作名称")
  private String adjustOperateName;

  /**
   * 调整类型编码
   */
  @ApiModelProperty("调整类型编码")
  private String adjustTypeCode;

  /**
   * 调整类型名称
   */
  @ApiModelProperty("调整类型名称")
  private String adjustTypeName;

  /**
   * 操作金额
   */
  @ApiModelProperty("操作金额")
  private BigDecimal operateAmount;

  /**
   * 当前长期授信额度
   */
  @ApiModelProperty("当前长期授信额度")
  private BigDecimal longAmount;

  /**
   * 当前长期授信可用余额
   */
  @ApiModelProperty("当前长期授信可用余额")
  private BigDecimal longCanUseAmount;

  /**
   * 资金流水业务扩展信息
   */
  @ApiModelProperty("资金流水业务扩展信息")
  private CreditCashFlowExtendVo extendInfo;
}
