package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 授信资金统计信息VO
 *
 * @author ning.zhang
 * @date 2021/12/21
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashStatsVo", description = "授信资金统计信息VO")
public class CreditCashStatsVo {

  /**
   * 已使用授信客户数量
   */
  @ApiModelProperty("已使用授信客户数量")
  private Integer haveUseCustomerNum;

  /**
   * 已使用总金额
   */
  @ApiModelProperty("已使用总金额")
  private BigDecimal haveUseTotalAmount;


}
