package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 授信资金VO
 *
 * @author ning.zhang
 * @date 2021/12/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashVo", description = "授信资金VO")
public class CreditCashVo {

  /**
   * 资金ID
   */
  @ApiModelProperty("资金ID")
  private String id;

  /**
   * 授信ID
   */
  @ApiModelProperty("授信ID")
  private String creditId;

  /**
   * 授信类型
   */
  @ApiModelProperty("授信类型")
  private String creditType;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 授信金额
   */
  @ApiModelProperty("授信金额")
  private BigDecimal creditAmount;

  /**
   * 冻结金额
   */
  @ApiModelProperty("冻结金额")
  private BigDecimal freezeAmount;

  /**
   * 占用额度
   */
  @ApiModelProperty("占用额度")
  private BigDecimal occupyAmount;

  /**
   * 已使用金额
   */
  @ApiModelProperty("已使用金额")
  private BigDecimal haveUseAmount;

  /**
   * 可用金额
   */
  @ApiModelProperty("可用金额")
  private BigDecimal canUseAmount;

}
