package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 授信信息VO
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditVo", description = "授信信息VO")
public class CreditEventVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 4893146570797125476L;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  private String creditType;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 授信编码
   */
  @ApiModelProperty("授信编码")
  private String creditCode;

  /**
   * 授信总额度
   */
  @ApiModelProperty("授信总额度")
  private BigDecimal creditAmount;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 还款截止时间
   */
  @ApiModelProperty("还款截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;

  /**
   * 授信文件信息
   */
  @ApiModelProperty("授信文件信息")
  private List<CreditFileVo> fileList;

  /**
   * 授信审批状态
   */
  @ApiModelProperty("授信审批状态")
  private String processStatus;
}
