package com.biz.crm.dms.business.costpool.credit.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 授信对账函数据统计VO
 *
 * @author ning.zhang
 * @date 2022/4/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditReconcileStatsVo", description = "授信对账函数据统计VO")
public class CreditReconcileStatsVo {

  /**
   * 期初余额
   */
  @ApiModelProperty("期初余额")
  private BigDecimal beginBalance;

  /**
   * 上账金额
   */
  @ApiModelProperty("上账金额")
  private BigDecimal upAccountAmount;

  /**
   * 使用金额
   */
  @ApiModelProperty("使用金额")
  private BigDecimal userAmount;

  /**
   * 占用总额度
   */
  @ApiModelProperty("占用总额度")
  private BigDecimal occupyAmount;

  /**
   * 期末余额
   */
  @ApiModelProperty("期末余额")
  private BigDecimal endBalance;

  /**
   * 授信总额度
   */
  @ApiModelProperty("授信总额度")
  private BigDecimal creditAmount;

}
