package com.biz.crm.dms.business.costpool.discount.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.feign.feign.CostPoolDiscountVoServiceFeign;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月21日 14:14:00
 */
@Component
@Slf4j
public class CostPoolDiscountVoServiceFeignImpl implements FallbackFactory<CostPoolDiscountVoServiceFeign> {

  @Override
  public CostPoolDiscountVoServiceFeign create(Throwable cause) {
    log.error("进入CostPoolDiscountVoServiceFeign熔断", cause);
    return new CostPoolDiscountVoServiceFeign() {

      @Override
      public Result<?> handleAdjust(CostPoolDiscountDto costPoolDiscountDto) {
        throw new UnsupportedOperationException("折扣费用池调整熔断");
      }
    };
  }
}
