package com.biz.crm.dms.business.costpool.discount.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.feign.feign.internal.CostPoolDiscountVoServiceFeignImpl;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年06月21日 14:12:00
 */
@FeignClient(
    name = "${dms.feign-client.name:crm-dms}",
    path = "crm-dms",
    fallbackFactory = CostPoolDiscountVoServiceFeignImpl.class)
public interface CostPoolDiscountVoServiceFeign {

  @PostMapping("/v1/costPoolDiscount/costPoolDiscount/handleAdjust")
  Result<?> handleAdjust(@ApiParam(name = "CostPoolDiscount", value = "折扣池请求对象") @RequestBody CostPoolDiscountDto costPoolDiscountDto);

}
