package com.biz.crm.dms.business.costpool.discount.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 折扣费用池，按照租户进行隔离(CostPoolDiscount)表相关的http接口
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@RestController
@RequestMapping("/v1/costPoolDiscount/costPoolDiscount")
@Slf4j
@Api(tags = "折扣费用池:CostPoolDiscount:折扣费用池")
public class CostPoolDiscountController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolDiscountService costPoolDiscountService;

  /**
   * 分页查询所有数据
   *
   * @param pageable         分页对象
   * @param costPoolDiscount 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolDiscount>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "CostPoolDiscount", value = "折扣费用池，按照租户进行隔离") CostPoolDiscount costPoolDiscount) {
    try {
      Page<CostPoolDiscount> page = this.costPoolDiscountService.findByConditions(pageable, costPoolDiscount);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolDiscount> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolDiscount CostPoolDiscount = this.costPoolDiscountService.findById(id);
      return Result.ok(CostPoolDiscount);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 调整折扣池
   *
   * @param costPoolDiscountDto 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "调整折扣池")
  @PostMapping("handleAdjust")
  public Result<?> handleAdjust(@ApiParam(name = "CostPoolDiscount", value = "折扣池请求对象") @RequestBody CostPoolDiscountDto costPoolDiscountDto) {
    try {
      this.costPoolDiscountService.handleAdjust(costPoolDiscountDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
