package com.biz.crm.dms.business.costpool.discount.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.DiscountOperationCustomerDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 费用池操作记录表实体类(CostPoolDiscountOperation)表相关的http接口
 *
 * @author songjingen
 * @since 2021-12-21 17:14:18
 */
@RestController
@RequestMapping("/v1/costPoolDiscount/costPoolDiscountOperation")
@Slf4j
@Api(tags = "折扣费用池操作记录:CostPoolDiscountOperation:折扣费用池操作记录")
public class CostPoolDiscountOperationController {
  /**
   * 服务对象
   */
  @Autowired(required = false)
  private CostPoolDiscountOperationService costPoolDiscountOperationService;

  /**
   * 分页查询所有数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountOperation 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CostPoolDiscountOperation>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "costPoolDiscountOperation", value = "费用池操作记录表实体类") CostPoolDiscountOperation costPoolDiscountOperation) {
    try {
      Page<CostPoolDiscountOperation> page = this.costPoolDiscountOperationService.findByConditions(pageable, costPoolDiscountOperation);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CostPoolDiscountOperation> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CostPoolDiscountOperation costPoolDiscountOperation = this.costPoolDiscountOperationService.findById(id);
      return Result.ok(costPoolDiscountOperation);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param costPoolDiscountOperation 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CostPoolDiscountOperation> create(@ApiParam(name = "costPoolDiscountOperation", value = "费用池操作记录表实体类") @RequestBody CostPoolDiscountOperation costPoolDiscountOperation) {
    try {
      CostPoolDiscountOperation result = this.costPoolDiscountOperationService.create(costPoolDiscountOperation);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-折扣操作明细分页查询
   *
   * @param pageable
   * @param dto
   */
  @ApiOperation(value = "客户-折扣操作明细分页查询")
  @GetMapping("/findByCapitalFlowCustomerDto")
  public Result<Page<CostPoolDiscountOperation>> findByDiscountOperationCustomerDto(
      @PageableDefault(50) Pageable pageable, DiscountOperationCustomerDto dto) {
    return Result.ok(this.costPoolDiscountOperationService.findByDiscountOperationCustomerDto(pageable, dto));
  }
}
