package com.biz.crm.dms.business.costpool.discount.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 费用池明细操作记录表
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dms_cost_pool_discount_detail_log")
@Entity
@Table(name = "dms_cost_pool_discount_detail_log", indexes = {@Index(name = "i_f_log_pool_code", columnList = "pool_code"),
    @Index(name = "i_f_log_pool_detail_code", columnList = "pool_detail_code"),
    @Index(name = "i_f_log_operation_code", columnList = "operation_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_cost_pool_discount_detail_log", comment = "折扣费用池明细记录表")
public class CostPoolDiscountDetailLog extends UuidOpEntity {
  /**
   * 费用池编号
   */
  @Column(name = "pool_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池编号'")
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 费用池明细编号
   */
  @Column(name = "pool_detail_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用池明细编号'")
  @ApiModelProperty(value = "费用池明细编号")
  private String poolDetailCode;
  /**
   * 操作记录编号
   */
  @Column(name = "operation_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作记录编号'")
  @ApiModelProperty(value = "操作记录编号")
  private String operationCode;
  /**
   * 操作类型
   */
  @Column(name = "operation_type", nullable = false, length = 8, columnDefinition = "VARCHAR(8) COMMENT '操作类型'")
  @ApiModelProperty(value = "操作类型")
  private String operationType;
  /**
   * 来源编号
   */
  @Column(name = "from_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '来源编号'")
  @ApiModelProperty(value = "来源编号")
  private String fromCode;
  /**
   * 来源描述
   */
  @Column(name = "from_desc", length = 128, columnDefinition = "VARCHAR(128) COMMENT '来源描述'")
  @ApiModelProperty(value = "来源描述")
  private String fromDesc;
  /**
   * 操作时间
   */
  @Column(name = "operation_date_time", nullable = false, columnDefinition = "datetime COMMENT '操作时间 yyyy-MM-dd HH:mm:ss'")
  @ApiModelProperty(value = "操作时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date operationDateTime;
  /**
   * 操作金额（数量）（含正负）
   */
  @Column(name = "operation_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT '操作金额（数量）（含正负）'")
  @ApiModelProperty(value = "操作金额（数量）（含正负）")
  private BigDecimal operationAmount;

  /**
   * 附件信息集合
   */
  @Transient
  @ApiModelProperty("附件信息集合")
  @TableField(exist = false)
  private Set<CostPoolDiscountFile> costPoolDiscountFiles;
}
