package com.biz.crm.dms.business.costpool.discount.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.DiscountOperationCustomerDto;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 费用池操作记录表实体类(CostPoolDiscountOperation)表mybatis访问层
 *
 * @author songjingen
 * @since 2021-12-21 17:14:18
 */
public interface CostPoolDiscountOperationMapper extends BaseMapper<CostPoolDiscountOperation> {

  /**
   * 分页查询所有数据
   *
   * @param page                      分页对象
   * @param costPoolDiscountOperation 查询实体
   * @return 所有数据
   */
  public Page<CostPoolDiscountOperation> findByConditions(@Param("page") Page<CostPoolDiscountOperation> page, @Param("costPoolDiscountOperation") CostPoolDiscountOperation costPoolDiscountOperation);

  /**
   * 客户-折扣操作明细分页查询
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CostPoolDiscountOperation> findByDiscountOperationCustomerDto(Page<CostPoolDiscountOperation> page, @Param("dto") DiscountOperationCustomerDto dto);

  /**
   * 根据客户编码和始末时间查询集合
   *
   * @param customerCode 客户编码
   * @param beginDate    开始时间
   * @param endDate      结束时间
   * @return 集合
   */
  List<CostPoolDiscountOperation> findByCustomerCodeAndDate(@Param("customerCode") String customerCode, @Param("beginDate") Date beginDate, @Param("endDate") Date endDate);
}

