package com.biz.crm.dms.business.costpool.discount.local.repository;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.mapper.CostPoolDiscountDetailLogMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 折扣费用池明细记录表(CostPoolDiscountDetailLog)表数据库访问层
 *
 * @author songjingen
 * @since 2021-12-21 17:12:41
 */
@Component
public class CostPoolDiscountDetailLogRepository extends ServiceImpl<CostPoolDiscountDetailLogMapper, CostPoolDiscountDetailLog> {

  @Autowired(required = false)
  private CostPoolDiscountDetailLogMapper costPoolDiscountDetailLogMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountDetailLog 实体对象
   * @return
   */
  public Page<CostPoolDiscountDetailLog> findByConditions(Pageable pageable, CostPoolDiscountDetailLog costPoolDiscountDetailLog) {
    Page<CostPoolDiscountDetailLog> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CostPoolDiscountDetailLog> pageList = costPoolDiscountDetailLogMapper.findByConditions(page, costPoolDiscountDetailLog);
    return pageList;
  }

  public List<String> findPoolDetailCodeByFormCode(String poolCode, String fromCode) {
    List<CostPoolDiscountDetailLog> list = this.lambdaQuery().select(CostPoolDiscountDetailLog::getPoolDetailCode).eq(CostPoolDiscountDetailLog::getPoolCode, poolCode)
        .eq(CostPoolDiscountDetailLog::getFromCode, fromCode).list();
    if (CollectionUtils.isEmpty(list)){
      return new ArrayList<>(0);
    }
    return list.stream().map(CostPoolDiscountDetailLog::getPoolDetailCode).collect(Collectors.toList());
  }
}

