package com.biz.crm.dms.business.costpool.discount.local.service;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 折扣费用池明细记录表(CostPoolDiscountDetailLog)表服务接口
 *
 * @author songjingen
 * @since 2021-12-21 17:12:41
 */
public interface CostPoolDiscountDetailLogService {

  /**
   * 分页查询数据
   *
   * @param pageable                  分页对象
   * @param costPoolDiscountDetailLog 实体对象
   * @return
   */
  Page<CostPoolDiscountDetailLog> findByConditions(Pageable pageable, CostPoolDiscountDetailLog costPoolDiscountDetailLog);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolDiscountDetailLog findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolDiscountDetailLog 实体对象
   * @return 新增结果
   */
  CostPoolDiscountDetailLog create(CostPoolDiscountDetailLog costPoolDiscountDetailLog);

  /**
   * 批量创建
   * @param detailLogList
   */
  void createBatch(List<CostPoolDiscountDetailLog> detailLogList);

  List<String> findPoolDetailCodeByFormCode(String poolCode, String fromCode);
}

