package com.biz.crm.dms.business.costpool.discount.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 折扣费用池明细,按照租户进行隔离(CostPoolDiscountDetail)表服务接口
 *
 * @author songjingen
 * @since 2021-12-21 16:46:05
 */
public interface CostPoolDiscountDetailService {

  /**
   * 分页查询数据
   *
   * @param pageable               分页对象
   * @param costPoolDiscountDetail 实体对象
   * @return
   */
  Page<CostPoolDiscountDetail> findByConditions(Pageable pageable, CostPoolDiscountDetail costPoolDiscountDetail);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolDiscountDetail findDetailsById(String id);

  /**
   * 新增数据
   *
   * @param costPoolDiscountDetail 实体对象
   * @return 新增结果
   */
  CostPoolDiscountDetail create(CostPoolDiscountDetail costPoolDiscountDetail);

  /**
   * 根据费用池编码查询数据集合
   *
   * @param poolCode
   * @return
   */
  List<CostPoolDiscountDetail> findByPoolCode(String poolCode);

  /**
   /**
   * 根据费用池编码及来源编码查询（此方法用于审批通过时找到审批前占用的哪个就扣哪个）
   * @param poolCode 费用池编码
   * @param fromCode 来源编码
   * @return
   */
  List<CostPoolDiscountDetail> findByPoolCodeAndFromCode(String poolCode, String fromCode);

  /**
   * 批量新增
   *
   * @param discountDetailList
   */
  void createBatch(List<CostPoolDiscountDetail> discountDetailList);

  /**
   * 批量更新
   *
   * @param discountDetailList
   */
  void updateBatch(List<CostPoolDiscountDetail> discountDetailList);

  /**
   * 根据折扣池明细编码查询信息
   *
   * @param poolDetailCode
   * @return
   */
  CostPoolDiscountDetail findByPoolDetailCode(String poolDetailCode);

  /**
   * 根据折扣池明细编码查询信息
   *
   * @param poolDetailCodes
   * @return
   */
  List<CostPoolDiscountDetail> findByPoolDetailCodes(List<String> poolDetailCodes);


  /**
   * 修改
   *
   * @param poolDiscountDetail
   */
  void update(CostPoolDiscountDetail poolDiscountDetail);

  /**
   * 调整折扣池明细
   *
   * @param costPoolDiscountDto
   */
  void handleAdjust(CostPoolDiscountDto costPoolDiscountDto);
}

