package com.biz.crm.dms.business.costpool.discount.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 折扣费用池，按照租户进行隔离(CostPoolDiscount)表服务接口
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
public interface CostPoolDiscountService {

  /**
   * 分页查询数据
   *
   * @param pageable         分页对象
   * @param costPoolDiscount 实体对象
   * @return
   */
  Page<CostPoolDiscount> findByConditions(Pageable pageable, CostPoolDiscount costPoolDiscount);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CostPoolDiscount findById(String id);

  /**
   * 新增数据
   *
   * @param costPoolDiscount 实体对象
   * @return 新增结果
   */
  void create(CostPoolDiscount costPoolDiscount);


  /**
   * 调整折扣池
   *
   * @param costPoolDiscountDto
   */
  void handleAdjust(CostPoolDiscountDto costPoolDiscountDto);

  /**
   * 根据类型和编码查看数据信息
   *
   * @param useType
   * @param customerCode
   * @return
   */
  CostPoolDiscount findByTypeAndCustomerCode(String useType, String customerCode);

  /**
   * 修改
   *
   * @param poolDiscount
   */
  void update(CostPoolDiscount poolDiscount);

  /**
   * 根据折扣池编码查询对象
   *
   * @param poolCode
   * @return
   */
  CostPoolDiscount findByPoolCode(String poolCode);

  /**
   * 根据客户编码查询
   *
   * @param customerCode
   * @return
   */
  List<CostPoolDiscount> findByCustomerCode(String customerCode);
}

