package com.biz.crm.dms.business.costpool.discount.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountHandleDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.HandleDiscountAdjustStrategy;
import com.biz.crm.dms.business.costpool.discount.sdk.vo.CostPoolDiscountVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 折扣池实现费用池观察者相关接口
 *
 * @author songjingen
 */
@Component
public class CostPoolDiscountStrategyImpl implements CostPoolStrategy {

  @Autowired(required = false)
  @Qualifier("CostPoolDiscountRegisterImpl")
  private CostPoolRegister costPoolRegister;
  @Autowired(required = false)
  private CostPoolDiscountService costPoolDiscountService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<HandleDiscountAdjustStrategy> handleDiscountAdjustStrategies;

  @Override
  public String getPoolTypeRegisterKey() {
    return costPoolRegister.getKey();
  }

  @Override
  public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
    List<CostPoolDiscount> byCustomerCode = this.costPoolDiscountService.findByCustomerCode(costPoolDto.getCustomerCode());
    if (CollectionUtils.isEmpty(byCustomerCode)) {
      return new ArrayList<>(0);
    }
    return (List) this.nebulaToolkitService.copyCollectionByWhiteList(byCustomerCode, CostPoolDiscount.class, CostPoolDiscountVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public void onHandleAdjust(JSONObject jsonObject) {
    Validate.isTrue(!CollectionUtils.isEmpty(handleDiscountAdjustStrategies), "费用池进行调整时，为获取到调整注册器！");
    CostPoolDiscountHandleDto costPoolDiscountHandleDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CostPoolDiscountHandleDto.class);
    String operationType = costPoolDiscountHandleDto.getOperationType();
    PoolOperationTypeEnum operationTypeEnum = PoolOperationTypeEnum.getByKey(operationType);
    String operationTypeGroup = operationTypeEnum.getGroup();
    for (HandleDiscountAdjustStrategy handleDiscountAdjustStrategy : handleDiscountAdjustStrategies) {
      if (handleDiscountAdjustStrategy.getOperationTypeGroup().equals(operationTypeGroup)) {
        handleDiscountAdjustStrategy.onHandleAdjust(costPoolDiscountHandleDto);
        break;
      }
    }
  }
}
