package com.biz.crm.dms.business.costpool.discount.local.service.strategy;


import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetailLog;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailLogService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountFileDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 折扣费用池，扣减操作类型组实现类
 *
 * @author songjingen
 * @since 2021-12-20 19:45:20
 */
@Component
public class UseOperationTypeStrategyImpl implements OperationTypeStrategy {

  @Autowired(required = false)
  private CostPoolDiscountRepository costPoolDiscountRepository;
  @Autowired(required = false)
  private CostPoolDiscountDetailService costPoolDiscountDetailService;
  @Autowired(required = false)
  private CostPoolDiscountDetailLogService costPoolDiscountDetailLogService;
  @Autowired(required = false)
  private CostPoolDiscountOperationService costPoolDiscountOperationService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return PoolOperationTypeGroupEnum.USE.getValue();
  }

  @Override
  @Transactional
  public void onSaveDiscountInfos(CostPoolDiscountDto costPoolDiscountDto) {
    /**
     * 1、修改费用池数据
     * 2、创建操作记录
     * 3、修改费用池明细数据，创建明细记录
     */
    Validate.notNull(costPoolDiscountDto.getPoolCode(), "进行使用扣减时，费用池编码必传！");
    Date date = new Date();
    BigDecimal amount = costPoolDiscountDto.getAmount();
    CostPoolDiscount poolDiscount = this.costPoolDiscountRepository.findByPoolCode(costPoolDiscountDto.getPoolCode());
    Validate.notNull(poolDiscount, "进行扣减时未查询到信息");
    //1、======
    poolDiscount.setHasUseAmount(poolDiscount.getHasUseAmount().add(amount));
    poolDiscount.setUsableAmount(poolDiscount.getUsableAmount().subtract(amount));
    this.costPoolDiscountRepository.updateById(poolDiscount);
    //2、======
    CostPoolDiscountOperation costPoolDiscountOperation = new CostPoolDiscountOperation();
    costPoolDiscountOperation.setPoolCode(poolDiscount.getPoolCode());
    costPoolDiscountOperation.setOperationType(costPoolDiscountDto.getOperationType());
    costPoolDiscountOperation.setFromCode(costPoolDiscountDto.getFromCode());
    costPoolDiscountOperation.setFromDesc(costPoolDiscountDto.getFromDesc());
    //流水顺序由调用时间区分，保证扣减在释放3000毫秒后的时间
    Date now = new Date();
    Date afterDate = new Date(now.getTime() + 3000);
    costPoolDiscountOperation.setCreateTime(afterDate);
    costPoolDiscountOperation.setOperationDateTime(afterDate);
    costPoolDiscountOperation.setOperationAmount(amount.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
    Set<CostPoolDiscountFileDto> costPoolDiscountFiles = costPoolDiscountDto.getCostPoolDiscountFiles();
    if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
      Set<CostPoolDiscountFile> files = (Set<CostPoolDiscountFile>) this.nebulaToolkitService.copyCollectionByWhiteList(costPoolDiscountFiles, CostPoolDiscountFileDto.class, CostPoolDiscountFile.class, HashSet.class, ArrayList.class);
      costPoolDiscountOperation.setCostPoolDiscountFiles(files);
    }
    costPoolDiscountOperationService.create(costPoolDiscountOperation);
    //3、======
    List<CostPoolDiscountDetail> discountDetailList = new ArrayList<>();
    List<CostPoolDiscountDetailLog> detailLogList = new ArrayList<>();
    List<CostPoolDiscountDetail> costPoolDiscountDetails;
    if (StringUtils.isNotBlank(costPoolDiscountDto.getFromCode())) {
      List<String> byFormCode = costPoolDiscountDetailLogService.findPoolDetailCodeByFormCode(costPoolDiscountDto.getPoolCode(), costPoolDiscountDto.getFromCode());
      Validate.notEmpty(byFormCode,String.format("%s订单未使用", costPoolDiscountDto.getFromCode()));
      costPoolDiscountDetails = this.costPoolDiscountDetailService.findByPoolDetailCodes(byFormCode);
    } else {
      costPoolDiscountDetails = this.costPoolDiscountDetailService.findByPoolCode(poolDiscount.getPoolCode());
    }
    for (CostPoolDiscountDetail discountDetail : costPoolDiscountDetails) {
      if (amount.compareTo(BigDecimal.ZERO) <= 0) {
        break;
      }
      //可用金额
      BigDecimal usableAmount = discountDetail.getUsableAmount();
      if (usableAmount.compareTo(BigDecimal.ZERO) > 0) {
        BigDecimal itemUse = BigDecimal.ZERO;
        if (usableAmount.compareTo(amount) >= 0) {
          itemUse = amount;
        } else {
          itemUse = usableAmount;
        }
        amount = amount.subtract(itemUse);
        Validate.isTrue(usableAmount.compareTo(itemUse) >= 0, "进行扣减时金额不能超过可用金额");
        discountDetail.setUsableAmount(usableAmount.subtract(itemUse));
        discountDetail.setHasUseAmount(discountDetail.getHasUseAmount().add(itemUse));
        discountDetailList.add(discountDetail);
        //组装明细日志数据
        CostPoolDiscountDetailLog costPoolDiscountDetailLog = this.nebulaToolkitService.copyObjectByBlankList(discountDetail, CostPoolDiscountDetailLog.class, HashSet.class, ArrayList.class, "id");
        costPoolDiscountDetailLog.setOperationDateTime(date);
        costPoolDiscountDetailLog.setOperationCode(costPoolDiscountOperation.getOperationCode());
        costPoolDiscountDetailLog.setOperationType(costPoolDiscountDto.getOperationType());
        costPoolDiscountDetailLog.setFromCode(costPoolDiscountDto.getFromCode());
        costPoolDiscountDetailLog.setFromDesc(costPoolDiscountDto.getFromDesc());
        costPoolDiscountDetailLog.setOperationAmount(itemUse.multiply(PoolOperationTypeGroupEnum.USE.getUsableAmountWeight()));
        detailLogList.add(costPoolDiscountDetailLog);
      }
    }
    Validate.isTrue(amount.compareTo(BigDecimal.ZERO) == 0, "费用池扣减异常");
    this.costPoolDiscountDetailService.updateBatch(discountDetailList);
    this.costPoolDiscountDetailLogService.createBatch(detailLogList);
  }
}

