/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountDetail;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountDetailRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountDetailService;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.DetailOperationTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="costPoolDiscountDetailService")
public class CostPoolDiscountDetailServiceImpl
implements CostPoolDiscountDetailService {
    @Autowired(required=false)
    private CostPoolDiscountDetailRepository costPoolDiscountDetailRepository;
    @Autowired(required=false)
    private CostPoolDiscountService costPoolDiscountService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private List<DetailOperationTypeStrategy> detailOperationTypeStrategies;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<CostPoolDiscountDetail> findByConditions(Pageable pageable, CostPoolDiscountDetail costPoolDiscountDetail) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)costPoolDiscountDetail)) {
            costPoolDiscountDetail = new CostPoolDiscountDetail();
        }
        costPoolDiscountDetail.setTenantCode(TenantUtils.getTenantCode());
        Page<CostPoolDiscountDetail> byConditions = this.costPoolDiscountDetailRepository.findByConditions(pageable, costPoolDiscountDetail);
        return byConditions;
    }

    @Override
    public CostPoolDiscountDetail findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new CostPoolDiscountDetail();
        }
        CostPoolDiscountDetail poolDetail = (CostPoolDiscountDetail)((Object)this.costPoolDiscountDetailRepository.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)poolDetail)) {
            return new CostPoolDiscountDetail();
        }
        CostPoolDiscount costPoolDiscount = this.costPoolDiscountService.findByPoolCode(poolDetail.getPoolCode());
        poolDetail.setCostPoolDiscount(costPoolDiscount);
        return poolDetail;
    }

    @Override
    @Transactional
    public CostPoolDiscountDetail create(CostPoolDiscountDetail costPoolDiscountDetail) {
        this.createForm(costPoolDiscountDetail);
        this.createValidate(costPoolDiscountDetail);
        this.costPoolDiscountDetailRepository.saveOrUpdate((Object)costPoolDiscountDetail);
        return costPoolDiscountDetail;
    }

    @Override
    public List<CostPoolDiscountDetail> findByPoolCode(String poolCode) {
        if (StringUtils.isBlank((CharSequence)poolCode)) {
            return null;
        }
        return this.costPoolDiscountDetailRepository.findByPoolCode(poolCode);
    }

    @Override
    public List<CostPoolDiscountDetail> findByPoolCodeAndFromCode(String poolCode, String fromCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{poolCode, fromCode})) {
            return new ArrayList<CostPoolDiscountDetail>(0);
        }
        return this.costPoolDiscountDetailRepository.findByPoolCodeAndFromCode(poolCode, fromCode);
    }

    @Override
    @Transactional
    public void createBatch(List<CostPoolDiscountDetail> discountDetailList) {
        if (CollectionUtils.isEmpty(discountDetailList)) {
            return;
        }
        for (CostPoolDiscountDetail costPoolDiscountDetail : discountDetailList) {
            this.createForm(costPoolDiscountDetail);
            this.createValidate(costPoolDiscountDetail);
        }
        this.costPoolDiscountDetailRepository.saveBatch(discountDetailList);
    }

    @Override
    @Transactional
    public void updateBatch(List<CostPoolDiscountDetail> discountDetailList) {
        if (CollectionUtils.isEmpty(discountDetailList)) {
            return;
        }
        this.costPoolDiscountDetailRepository.updateBatchById(discountDetailList);
    }

    @Override
    public CostPoolDiscountDetail findByPoolDetailCode(String poolDetailCode) {
        if (StringUtils.isBlank((CharSequence)poolDetailCode)) {
            return null;
        }
        return this.costPoolDiscountDetailRepository.findByPoolDetailCode(poolDetailCode);
    }

    @Override
    public List<CostPoolDiscountDetail> findByPoolDetailCodes(List<String> poolDetailCodes) {
        if (CollectionUtils.isEmpty(poolDetailCodes)) {
            return null;
        }
        return this.costPoolDiscountDetailRepository.findByPoolDetailCodes(poolDetailCodes);
    }

    @Override
    @Transactional
    public void update(CostPoolDiscountDetail poolDiscountDetail) {
        Validate.notNull((Object)((Object)poolDiscountDetail), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)poolDiscountDetail.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        poolDiscountDetail.setModifyTime(new Date());
        poolDiscountDetail.setModifyAccount(loginUser.getAccount());
        poolDiscountDetail.setModifyName(loginUser.getUsername());
        this.costPoolDiscountDetailRepository.updateById((Object)poolDiscountDetail);
    }

    @Override
    @Transactional
    public void handleAdjust(CostPoolDiscountDto costPoolDiscountDto) {
        this.handleAdjustValidate(costPoolDiscountDto);
        PoolOperationTypeEnum operationTypeEnum = PoolOperationTypeEnum.getByKey((String)costPoolDiscountDto.getOperationType());
        Validate.notNull((Object)operationTypeEnum, (String)"\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\u7c7b\u578b\u8fdb\u884c\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        String operationTypeGroup = operationTypeEnum.getGroup();
        Validate.isTrue((!CollectionUtils.isEmpty(this.detailOperationTypeStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7c7b\u578b\u5bf9\u5e94\u7684\u7b56\u7565\u5b9e\u73b0", (Object[])new Object[0]);
        for (DetailOperationTypeStrategy operationTypeStrategy : this.detailOperationTypeStrategies) {
            String group = operationTypeStrategy.getOperationTypeGroup();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)operationTypeGroup)) continue;
            operationTypeStrategy.onSaveDiscountInfos(costPoolDiscountDto);
            break;
        }
    }

    private void createValidate(CostPoolDiscountDetail costPoolDiscountDetail) {
        Validate.notNull((Object)((Object)costPoolDiscountDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolDiscountDetail.setId(null);
        costPoolDiscountDetail.setPoolDetailCode((String)this.generateCodeService.generateCode("ZKMX", 1).get(0));
        Validate.notBlank((CharSequence)costPoolDiscountDetail.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountDetail.getAccountDateTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0a\u8d26\u65f6\u95f4 yyyy-MM-dd HH:mm:ss\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountDetail.getFreezeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u51bb\u7ed3\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountDetail.getHasUseAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5df2\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountDetail.getOccupyAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5360\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscountDetail.getOperationCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscountDetail.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscountDetail.getPoolCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscountDetail.getPoolDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountDetail.getTotalAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u603b\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountDetail.getUsableAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5269\u4f59\u53ef\u4f7f\u7528\u91d1\u989d\uff08\u6570\u91cf\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createForm(CostPoolDiscountDetail costPoolDiscountDetail) {
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        Date date = new Date();
        costPoolDiscountDetail.setCreateAccount(loginUser.getAccount());
        costPoolDiscountDetail.setCreateName(loginUser.getUsername());
        costPoolDiscountDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        costPoolDiscountDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costPoolDiscountDetail.setCreateTime(date);
        costPoolDiscountDetail.setModifyAccount(loginUser.getAccount());
        costPoolDiscountDetail.setModifyName(loginUser.getUsername());
        costPoolDiscountDetail.setModifyTime(date);
        costPoolDiscountDetail.setTenantCode(TenantUtils.getTenantCode());
    }

    private void handleAdjustValidate(CostPoolDiscountDto costPoolDiscount) {
        Validate.notNull((Object)costPoolDiscount, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscount.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscount.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscount.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((costPoolDiscount.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        List byCustomerCodes = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{costPoolDiscount.getCustomerCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)byCustomerCodes) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        costPoolDiscount.setCustomerName(((CustomerVo)byCustomerCodes.get(0)).getCustomerName());
        Validate.notBlank((CharSequence)costPoolDiscount.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

