/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountFile;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscountOperation;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountFileRepository;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountOperationRepository;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountOperationService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.DiscountOperationCustomerDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.CostPoolDiscountOperationGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="costPoolDiscountOperationService")
public class CostPoolDiscountOperationServiceImpl
implements CostPoolDiscountOperationService {
    @Autowired(required=false)
    private CostPoolDiscountOperationRepository costPoolDiscountOperationRepository;
    @Autowired(required=false)
    private CostPoolDiscountFileRepository costPoolDiscountFileRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CostPoolDiscountRepository costPoolDiscountRepository;

    @Override
    public Page<CostPoolDiscountOperation> findByConditions(Pageable pageable, CostPoolDiscountOperation costPoolDiscountOperation) {
        org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)costPoolDiscountOperation)) {
            costPoolDiscountOperation = new CostPoolDiscountOperation();
        }
        return this.costPoolDiscountOperationRepository.findByConditions(pageable, costPoolDiscountOperation);
    }

    @Override
    public CostPoolDiscountOperation findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (CostPoolDiscountOperation)((Object)this.costPoolDiscountOperationRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public CostPoolDiscountOperation create(CostPoolDiscountOperation costPoolDiscountOperation) {
        this.createValidate(costPoolDiscountOperation);
        this.costPoolDiscountOperationRepository.saveOrUpdate((Object)costPoolDiscountOperation);
        Set<CostPoolDiscountFile> costPoolDiscountFiles = costPoolDiscountOperation.getCostPoolDiscountFiles();
        if (!CollectionUtils.isEmpty(costPoolDiscountFiles)) {
            costPoolDiscountFiles.stream().forEach(costPoolDiscountFile -> {
                costPoolDiscountFile.setPoolCode(costPoolDiscountOperation.getPoolCode());
                costPoolDiscountFile.setOperationCode(costPoolDiscountOperation.getOperationCode());
                costPoolDiscountFile.setId(null);
            });
            this.costPoolDiscountFileRepository.saveBatch(costPoolDiscountFiles);
        }
        return costPoolDiscountOperation;
    }

    private void createValidate(CostPoolDiscountOperation costPoolDiscountOperation) {
        Validate.notNull((Object)((Object)costPoolDiscountOperation), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolDiscountOperation.setId(null);
        costPoolDiscountOperation.setOperationCode((String)this.generateCodeService.generateCode("ZKOP", 1).get(0));
        Validate.notNull((Object)costPoolDiscountOperation.getOperationAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\uff08\u6570\u91cf\uff09\uff08\u542b\u6b63\u8d1f\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountOperation.getOperationCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u8bb0\u5f55\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountOperation.getOperationDateTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4 yyyy-MM-dd HH:mm:ss\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountOperation.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscountOperation.getPoolCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6c60\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    public Page<CostPoolDiscountOperation> findByDiscountOperationCustomerDto(Pageable pageable, DiscountOperationCustomerDto dto) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        Page pageResultEmpty = new Page(0L, 0L, 0L);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode())) {
            return pageResultEmpty;
        }
        List<CostPoolDiscount> costPoolDiscountList = this.costPoolDiscountRepository.findByCustomer(loginUserDetails.getCustomerCode());
        if (CollectionUtils.isEmpty(costPoolDiscountList)) {
            return pageResultEmpty;
        }
        CostPoolDiscount costPoolDiscount = costPoolDiscountList.get(0);
        dto.setPoolCode(costPoolDiscount.getPoolCode());
        Validate.notBlank((CharSequence)dto.getGroup(), (String)"\u4e0a\u8d26/\u4f7f\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostPoolDiscountOperationGroupEnum groupEnum = CostPoolDiscountOperationGroupEnum.getByKey((String)dto.getGroup());
        Validate.isTrue((!ObjectUtils.isEmpty((Object)groupEnum) ? 1 : 0) != 0, (String)"\u4e0a\u8d26/\u4f7f\u7528\u6807\u8bc6\u9519\u8bef", (Object[])new Object[0]);
        List operationTypeList = PoolOperationTypeEnum.getDictCodeByGroupEnum((CostPoolDiscountOperationGroupEnum)groupEnum);
        dto.setOperationTypeList(operationTypeList);
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CostPoolDiscountOperation> entityResult = this.costPoolDiscountOperationRepository.findByDiscountOperationCustomerDto((Page<CostPoolDiscountOperation>)page, dto);
        return entityResult;
    }

    @Override
    public List<CostPoolDiscountOperation> findByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
        if (StringUtils.isBlank((CharSequence)customerCode) || beginDate == null && endDate == null) {
            return new ArrayList<CostPoolDiscountOperation>();
        }
        return this.costPoolDiscountOperationRepository.findByCustomerCodeAndDate(customerCode, beginDate, endDate);
    }

    @Override
    public List<CostPoolDiscountOperation> findByFromCode(String fromCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fromCode})) {
            return new ArrayList<CostPoolDiscountOperation>(0);
        }
        return this.costPoolDiscountOperationRepository.findByFromCode(fromCode);
    }
}

