/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.discount.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.discount.local.entity.CostPoolDiscount;
import com.biz.crm.dms.business.costpool.discount.local.repository.CostPoolDiscountRepository;
import com.biz.crm.dms.business.costpool.discount.local.service.CostPoolDiscountService;
import com.biz.crm.dms.business.costpool.discount.sdk.dto.CostPoolDiscountDto;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolGroupEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolOperationTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolPayTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.enums.PoolUseTypeEnum;
import com.biz.crm.dms.business.costpool.discount.sdk.strategy.OperationTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="CostPoolDiscountService")
public class CostPoolDiscountServiceImpl
implements CostPoolDiscountService {
    @Autowired(required=false)
    private CostPoolDiscountRepository costPoolDiscountRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private List<OperationTypeStrategy> operationTypeStrategies;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Override
    public Page<CostPoolDiscount> findByConditions(Pageable pageable, CostPoolDiscount costPoolDiscount) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)costPoolDiscount)) {
            costPoolDiscount = new CostPoolDiscount();
        }
        return this.costPoolDiscountRepository.findByConditions(pageable, costPoolDiscount);
    }

    @Override
    public CostPoolDiscount findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (CostPoolDiscount)((Object)this.costPoolDiscountRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public void create(CostPoolDiscount costPoolDiscount) {
        this.createForm(costPoolDiscount);
        this.costPoolDiscountRepository.save((Object)costPoolDiscount);
    }

    @Override
    @Transactional
    public void handleAdjust(CostPoolDiscountDto costPoolDiscountDto) {
        this.handleAdjustValidate(costPoolDiscountDto);
        PoolOperationTypeEnum operationTypeEnum = PoolOperationTypeEnum.getByKey((String)costPoolDiscountDto.getOperationType());
        Validate.notNull((Object)operationTypeEnum, (String)"\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\u7c7b\u578b\u8fdb\u884c\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        String operationTypeGroup = operationTypeEnum.getGroup();
        Validate.isTrue((!CollectionUtils.isEmpty(this.operationTypeStrategies) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7c7b\u578b\u5bf9\u5e94\u7684\u7b56\u7565\u5b9e\u73b0", (Object[])new Object[0]);
        for (OperationTypeStrategy operationTypeStrategy : this.operationTypeStrategies) {
            String group = operationTypeStrategy.getOperationTypeGroup();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)operationTypeGroup)) continue;
            operationTypeStrategy.onSaveDiscountInfos(costPoolDiscountDto);
            break;
        }
    }

    @Override
    public CostPoolDiscount findByTypeAndCustomerCode(String useType, String customerCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{useType, customerCode})) {
            return null;
        }
        return this.costPoolDiscountRepository.findByTypeAndCustomerCode(useType, customerCode);
    }

    @Override
    @Transactional
    public void update(CostPoolDiscount poolDiscount) {
        Validate.notNull((Object)((Object)poolDiscount), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)poolDiscount.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        poolDiscount.setModifyTime(new Date());
        poolDiscount.setModifyAccount(loginUser.getAccount());
        poolDiscount.setModifyName(loginUser.getUsername());
        this.costPoolDiscountRepository.updateById((Object)poolDiscount);
    }

    @Override
    public CostPoolDiscount findByPoolCode(String poolCode) {
        if (StringUtils.isBlank((CharSequence)poolCode)) {
            return null;
        }
        return this.costPoolDiscountRepository.findByPoolCode(poolCode);
    }

    @Override
    public List<CostPoolDiscount> findByCustomerCode(String customerCode) {
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return null;
        }
        return this.costPoolDiscountRepository.findByCustomer(customerCode);
    }

    private void handleAdjustValidate(CostPoolDiscountDto costPoolDiscount) {
        Validate.notNull((Object)costPoolDiscount, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscount.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolDiscount.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolDiscount.getOperationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((costPoolDiscount.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        List byCustomerCodes = this.customerVoService.findByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{costPoolDiscount.getCustomerCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)byCustomerCodes) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        costPoolDiscount.setCustomerName(((CustomerVo)byCustomerCodes.get(0)).getCustomerName());
        Validate.notBlank((CharSequence)costPoolDiscount.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createForm(CostPoolDiscount costPoolDiscount) {
        LoginDetails loginUser = this.loginUserService.getLoginUser();
        Date date = new Date();
        costPoolDiscount.setPoolCode((String)this.generateCodeService.generateCode("ZK", 1).get(0));
        costPoolDiscount.setCreateAccount(loginUser.getAccount());
        costPoolDiscount.setCreateName(loginUser.getUsername());
        costPoolDiscount.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        costPoolDiscount.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costPoolDiscount.setCreateTime(date);
        costPoolDiscount.setModifyAccount(loginUser.getAccount());
        costPoolDiscount.setModifyName(loginUser.getUsername());
        costPoolDiscount.setModifyTime(date);
        costPoolDiscount.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isBlank((CharSequence)costPoolDiscount.getPoolGroup())) {
            costPoolDiscount.setPoolGroup(PoolGroupEnum.DEFAULT.getDictCode());
        }
        if (StringUtils.isBlank((CharSequence)costPoolDiscount.getPoolType())) {
            costPoolDiscount.setPoolType(PoolTypeEnum.DISCOUNT.getDictCode());
        }
        if (StringUtils.isBlank((CharSequence)costPoolDiscount.getPoolType())) {
            costPoolDiscount.setPayType(PoolPayTypeEnum.DISCOUNT.getDictCode());
        }
        if (StringUtils.isBlank((CharSequence)costPoolDiscount.getPoolType())) {
            costPoolDiscount.setUseType(PoolUseTypeEnum.DEFAULT.getDictCode());
        }
    }
}

